from svggen.api.component import Component
from svggen.api.Function import Function

c = Component()

c.addSubcomponent("f1","Finger")
c.addSubcomponent("f2","Finger")
c.addSubcomponent("f3","Finger")
c.addSubcomponent("palm","RectBeam")
c.addSubcomponent("split","SplitEdge")

c.addParameter("length")
c.addParameter("palmwidth")
c.addParameter("fingerwidth")

c.addConstraint(("split","toplength"),("palmwidth","fingerwidth"),
                "[(x[0]-x[1])/2.,x[1],(x[0]-x[1])/2.]")
c.addConstraint(("split","botlength"),"palmwidth","[x]")

c.addConstraint(("f1","length"),"length", "x/2.")
c.addConstraint(("f1","beamwidth"),"fingerwidth")
c.addConstConstraint(("f1","ratio"),1)
c.addConstConstraint(("f1","phase"),2)

c.addConstraint(("f2","length"),"length", "x/2.")
c.addConstraint(("f2","beamwidth"),"fingerwidth")
c.addConstConstraint(("f2","ratio"),1)
c.addConstConstraint(("f2","phase"),2)

c.addConstraint(("f3","length"), "length", "x/2.")
c.addConstraint(("f3","beamwidth"),"fingerwidth")
c.addConstConstraint(("f3","ratio"),1)
c.addConstConstraint(("f3","phase"),2)

c.addConstraint(("palm","length"), "length")
c.addConstraint(("palm","width"), "palmwidth")
c.addConstraint(("palm","depth"),"fingerwidth","x*2")
c.addConstConstraint(("palm","faces"),range(4))
c.addConstConstraint(("palm","phase"),2)

c.addConnection(("palm","botedge1"),("f1","botedge"),angle=-30)
c.addConnection(("palm","botedge3"),("f2","botedge"),angle=-30)
c.addConnection(("palm","botedge2"),("split","botedge0"))
c.addConnection(("split","topedge1"),("f3","botedge"),angle=-30)

c.toYaml("library/ThreeFingerHand.yaml")
