from svggen.api.component import Component

c = Component()

c.addParameter("l")
c.addParameter("w")

"""
FEET
"""
c.addSubcomponent("botsplit", "SplitEdge")
c.addSubcomponent("dovetail","Dovetail")
c.addSubcomponent("topsplit", "SplitEdge")

c.addConstraint(("botsplit","botlength"), "w", "[x]")                          
c.addConstraint(("botsplit","toplength"), "w", "[x/2., x/2.]")                          

c.addConstraint(("topsplit","botlength"), "w", "[x/2., x/2.]")                          
c.addConstraint(("topsplit","toplength"), "w", "[x]")                          

c.addConstraint(("dovetail", "width"), "w", "x/2.")
c.addConstraint(("dovetail", "length"), ("l", "w"), "(x[0] - 2*x[1])/2.")
c.addConstraint(("dovetail", "pitch"), "w", "x/3.")
c.addConstConstraint(("dovetail", "dx"), 0.25)
c.addConstConstraint(("dovetail", "dy"), 0.125)

c.addConnection(("botsplit", "topedge0"), ("dovetail", "botedge"))
c.addConnection(("dovetail", "topedge"), ("topsplit", "botedge0"))

c.inheritInterface("botedge", ("botsplit", "botedge0"))
c.inheritInterface("topedge", ("topsplit", "topedge0"))

c.toYaml("library/TableFoot.yaml")
