from svggen.api.component import Component

c = Component()

""" 
TABLETOP
"""

c.addParameter("l")
c.addParameter("w")

c.addSubcomponent("toprect","Rectangle")
c.addSubcomponent("botrect","Rectangle")
c.addSubcomponent("ltrect","Rectangle")
c.addSubcomponent("rtrect","Rectangle")

c.addSubcomponent("topsplit","SplitEdge")
c.addSubcomponent("botsplit","SplitEdge")

c.addConstraint(("toprect","l"), "w", "x * 7")
c.addConstraint(("toprect","w"), "w")
c.addConstraint(("botrect","l"), "w", "x * 7")
c.addConstraint(("botrect","w"), "w")

c.addConstraint(("ltrect","l"), "w")
c.addConstraint(("ltrect","w"), "l")
c.addConstraint(("rtrect","l"), "w")
c.addConstraint(("rtrect","w"), "l")

c.addConstraint(("topsplit","toplength"), "w", "[x*7]")
c.addConstraint(("topsplit","botlength"), "w", "[x]*7")

c.addConstraint(("botsplit","toplength"), "w", "[x]*7")
c.addConstraint(("botsplit","botlength"), "w", "[x*7]")

c.addConnection(("botrect", "t"), ("botsplit", "botedge0"))
c.addConnection(("botsplit", "topedge0"), ("ltrect", "b"))
c.addConnection(("botsplit", "topedge6"), ("rtrect", "b"))
c.addConnection(("topsplit", "botedge6"), ("rtrect", "t"))
c.addConnection(("topsplit", "botedge0"), ("ltrect", "t"))
c.addConnection(("topsplit", "topedge0"), ("toprect", "b"))

""" 
LEGS
"""

c.addSubcomponent("r","FlexLeg", inherit=True, prefix=None)
c.addSubcomponent("c","FlexLeg", inherit=True, prefix=None)
c.addSubcomponent("l","FlexLeg", inherit=True, prefix=None)

c.addConstConstraint(("r","rw"), 0)
c.addConstConstraint(("l","lw"), 0)

c.addConstraint(("r", "l"), ("l", "w", "cols", "width", "gap"), "x[0] - x[1] - 2*x[2]*(x[3] + x[4])")
c.addConstraint(("c", "l"), ("l", "w", "cols", "width", "gap"), "x[0] - x[1] - 2*x[2]*(x[3] + x[4])")
c.addConstraint(("l", "l"), ("l", "w", "cols", "width", "gap"), "x[0] - x[1] - 2*x[2]*(x[3] + x[4])")

c.addConnection(("r", "legedge"), ("botsplit", "topedge1"))
c.addConnection(("c", "legedge"), ("topsplit", "botedge3"))
c.addConnection(("l", "legedge"), ("botsplit", "topedge5"))

"""
FEET
"""
c.addSubcomponent("rrfoot","TableFoot", inherit=True, prefix=None)
c.addSubcomponent("rcfoot","TableFoot", inherit=True, prefix=None)
c.addSubcomponent("lcfoot","TableFoot", inherit=True, prefix=None)
c.addSubcomponent("llfoot","TableFoot", inherit=True, prefix=None)

c.addConnection(("rrfoot", "botedge"), ("r", "leftedge"))
c.addConnection(("rcfoot", "botedge"), ("c", "leftedge"))
c.addConnection(("lcfoot", "topedge"), ("c", "rightedge"))
c.addConnection(("llfoot", "topedge"), ("l", "rightedge"))

c.toYaml("library/Table.yaml")
