from svggen.api.component import Component
from svggen.api.Function import Function


self = Component()

# Subcomponents used in this assembly
self.addSubcomponent("stem", "RectBeam")
self.addSubcomponent("left", "RectBeam")
self.addSubcomponent("right", "RectBeam")
self.addSubcomponent("t", "TJoint")

# New free parameters specific to this assembly are added
self.addParameter("stemlength")
self.addParameter("leftlength")
self.addParameter("rightlength")
self.addParameter("crosswidth")
self.addParameter("stemwidth")
self.addParameter("thickness")

### Set specific relationships between parameters
self.addConstraint(("stem", "depth"), "thickness")
self.addConstraint(("stem", "width"), "stemwidth")
self.addConstraint(("stem", "length"), "stemlength")

self.addConstraint(("left", "depth"), "crosswidth")
self.addConstraint(("left", "width"), "thickness")
self.addConstraint(("left", "length"), "leftlength")

self.addConstraint(("right", "depth"), "crosswidth")
self.addConstraint(("right", "width"), "thickness")
self.addConstraint(("right", "length"), "rightlength")

self.addConstraint(("t", "thickness"), "crosswidth")
self.addConstraint(("t", "crosswidth"), "thickness")
self.addConstraint(("t", "stemwidth"), "stemwidth")

for i in range(3):
  self.addConnection(("t", "leftedge%d" % i),
                     ("left", "topedge%d" % (3-i)), angle=0)
  self.addConnection(("t", "rightedge%d" % i),
                     ("right", "botedge%d" % (3-i)), angle=0)
self.addConnection(("t", "stemedge"),
                   ("stem", "topedge0"), angle=0)
self.addConnection(("t", "stemtab"),
                   ("stem", "topedge2"),
                   angle=0, tabWidth=Function("stemlength", "min(x, 10)"))

for i in range(4):
  self.inheritInterface("topedge%d"%i, ("right", "topedge%d"%i))
  self.inheritInterface("botedge%d"%i, ("left", "botedge%d"%i))
  self.inheritInterface("stemedge%d"%i, ("stem", "botedge%d"%i))
self.inheritInterface("rightface", ("right", "face0"))
self.inheritInterface("leftface", ("left", "face0"))

self.inheritAllInterfaces("t", prefix=None)

self.toYaml("library/TBar.yaml")
