from svggen.api.component import Component

c = Component()

c.addSubcomponent("top","Rectangle")
c.addSubcomponent("legl","VLeg", inherit=True, prefix=None)
c.addSubcomponent("legr","VLeg", inherit=True, prefix=None)
c.addSubcomponent("legt","VLeg", inherit=True, prefix=None)
c.addSubcomponent("legb","VLeg", inherit=True, prefix=None)

c.addParameter("length", 70, paramtype="length")

c.addConstraint(("top","l"), "length")
c.addConstraint(("top","w"), "width")

c.addConstraint(("legt","width"), "length")
c.addConstraint(("legb","width"), "length")

c.addConnection(("top","l"),("legl","topedge"), angle=90)
c.addConnection(("top","r"),("legr","topedge"), angle=90)
c.addConnection(("top","t"),("legt","topedge"), angle=90)
c.addConnection(("top","b"),("legb","topedge"), angle=90)

c.addConnection(("legl","rightedge"),("legb","leftedge"), angle=90)
c.addConnection(("legb","rightedge"),("legr","leftedge"), angle=90)
c.addConnection(("legr","rightedge"),("legt","leftedge"), angle=90)
c.addConnection(("legt","rightedge"),("legl","leftedge"), angle=90)

c.toYaml("library/SimpleTable.yaml")
