from svggen.api.component import Component
from svggen.api.Function import Function

c = Component("library/Core.yaml")

c.addParameter("driveservo")
c.addParameter("height")

# depth = ("controller", "driveservo"), "max(x[0].getDimension('height'), x[1].getParameter('motorwidth'))"
c.addConstraint(("brain","width"), "width", "x/3")

for servo in ["right", "left"]:
  c.addSubcomponent(servo, "Wheel", inherit=("controller", "length", "depth", "shift", "height"), prefix=None)
  c.addConstraint((servo,"width"), "width", "x/3")
  c.addConstraint((servo,"servo"), "driveservo")
  c.addConstConstraint((servo, 'center'), False)
  c.addConstConstraint((servo, 'label'), servo)

c.addConstConstraint(('left', 'flip'), True)
c.addConstConstraint(("left","shift"), 6)
c.addConstConstraint(("right","shift"), 6)

c.addConnection(("brain", "topedge2"),
                ("right", "topedge0"),
                angle=-180)
c.addConnection(("right", "botedge0"),
                ("brain", "botedge2"),
                angle=-180, tabWidth=Function(params="length"))

c.addConnection(("brain", "botedge0"),
                ("left", "topedge0"),
                angle=-180)
c.addConnection(("left", "botedge0"),
                ("brain", "topedge0"),
                angle=-180, tabWidth=Function(params="length"))

c.addSubcomponent("bumper", "Bumper", inherit=("height", "depth"),            prefix=None, invert=True)
c.addConstraint(("bumper", "length"), "width")
c.addConstConstraint(("bumper", "width"), 10)

c.addConnection(("right", "botedge2"),
                ("bumper", "topedge1"),
                angle=90)
c.addConnection(("bumper", "botedge1"),
                ("left", "topedge2"),
                angle=90, tabWidth=10)

c.toYaml("library/SegBase.yaml")
