from numbers import Number

from svggen.api.component import Component


c = Component()

c.addParameter("height", 40, paramtype="length")
c.addParameter("depth", 50, paramtype="length")
c.addParameter("thickness", 10, paramtype="length")
c.addParameter("rocker", 10, paramtype="angle")
c.addParameter("flip", 0, paramtype="boolean")

l = [
    ["depth"], 
    (("height", "rocker", "flip"), "1 * x[0] * np.sin(np.deg2rad(x[1] * x[2]))"), 
    (("height", "rocker", "flip"), "1 * x[0] * np.sin(np.deg2rad(x[1] * x[2]))"), 
    ["height"], 
    ["depth"], 
    ["height"], 
    (("height", "rocker", "flip"), "1 * x[0] * np.sin(np.deg2rad(x[1] * (1-x[2])))"),
    (("height", "rocker", "flip"), "1 * x[0] * np.sin(np.deg2rad(x[1] * (1-x[2])))"),
    ]

a = [ 
    [["rocker", "flip"], "x[0] * x[1]"], 
    0,
    (["rocker", "flip"], "90+(x[0] * x[1])"), 
    [["rocker", "flip"], "90-(x[0]*2 * x[1])"], 
    [["rocker", "flip"], "90-(x[0]*2 * (1-x[1]))"], 
    (["rocker", "flip"], "90+(x[0] * (1-x[1]))"), 
    0,
    [["rocker", "flip"], "x[0] * (1 - x[1])"],
    ]

n = len(l)

for i in range(n):
    c.addSubcomponent("beam%d" % i, "Rectangle")
    c.addSubcomponent("kite%d" % i, "Kite", inherit="thickness", prefix=None)

    c.addConstraint(("beam%d" % i, "w"), *l[i])
    c.addConstraint(("beam%d" % i, "l"), "thickness")
    if isinstance(a[i], Number):
        c.addConstConstraint(("kite%d" % i, "angle"), a[i])
    else:
        c.addConstraint(("kite%d" % i, "angle"), *a[i])

    c.addConnection(("beam%d" % i,"t"),("kite%d" % i,"b"), angle=0)
    c.addConnection(("beam%d" % i,"b"),("kite%d" % ((i - 1) % n),"t"), angle=0)


c.inheritInterface("topedge", ("beam4", "r"))
c.inheritInterface("crossbar", ("beam7", "l"))
c.inheritInterface("crossbarflip", ("beam1", "l"))

c.toYaml("library/RockerLeg.yaml")
