from svggen.api.component import Component

c = Component()

c.addSubcomponent("seat","ChairSeat", inherit=True, prefix=None)
c.addSubcomponent("legl","RockerLeg", inherit=True, prefix=None)
c.addSubcomponent("legr","RockerLeg", inherit=True, prefix=None)
c.addSubcomponent("crossbar","Rectangle")

c.delParameter("flip")

c.addConstConstraint(("legl","flip"), 1)
c.addConstConstraint(("legr","flip"), 0)

c.addConstraint(("crossbar","l"), "width")
c.addConstraint(("crossbar","w"), ("height", "rocker"), "x[0] * np.sin(np.deg2rad(x[1]))")

c.addConnection(("seat","left"),("legl","topedge"), angle=0)
c.addConnection(("seat","right"),("legr","topedge"), angle=0)

c.addConnection(("crossbar","l"),("legl","crossbarflip"), angle=90)
c.addConnection(("crossbar","r"),("legr","crossbar"), angle=90)

c.toYaml("library/RockerChair.yaml")
