from svggen.utils.Modular import Modular

from svggen.library.Arduino import ArduinoProMini
from svggen.utils.dimensions import tgy1370a, fs90r

c = ArduinoProMini()
height = 5
width = fs90r.getParameter("motorheight")


components = [
  ("gripper", "MountedGripper", "Fx", {
    "controller": c,
    "servo": tgy1370a,
    "fingerlength": 50,
    "fingerwidth": 5,
  }),
  ("b", "Bumper", "Bx", {
    "depth": 18,
    "height": height,
  }),
  ("l", "Servo", "L", {
    "controller": c,
    "servo": fs90r,
    "shift": 5,
    "center": False,
    "flip": True,
    "width": width,
  }),
  ("r", "Servo", "R", {
    "controller": c,
    "servo": fs90r,
    "shift": 5,
    "center": False,
    "width": width,
  }),
]

devices = [
  ("ld", "LineDetector", 
   "Fx", 1, "mount", {
     "offset": (0, 0),
   }, {
     "controller": c,
   }),

  ("td", "TouchSensor", 
   "Fx", 0, "mount", {
   }, {
     "controller": c,
   }),

  ("flag", "MountableServo", 
   "Bx", 0, "mount", {
     "offset": (0, 10),
   }, {
     "controller": c,
     "servo": tgy1370a,
   }),

  ("atGoal", "UIToggle", 
   None, None, None, {}, {
     "controller": c,
     "label": "At object?",
   }),

  ("haveObject", "UIToggle", 
   None, None, None, {}, {
     "controller": c,
     "label": "Has object...",
   }),
]

self = Modular(components, devices, 
               brainlen=49, controller=c, 
               yamlFile="test.yaml").getComponent()

self.makeOutput("output/robot2", display=True)
