from svggen.utils.Modular import Modular

from svggen.library.Arduino import ArduinoProMini
from svggen.utils.dimensions import tgy1370a, fs90r

c = ArduinoProMini()
height = 5
width = fs90r.getParameter("motorheight")

components = [
  ("rbuzz", "RectBeam", "F", {
    "length": 20,
  }),
  ("rld", "RectBeam", "F", {
    "length": 20,
  }),
  ("fork", "Forklift", "F", {
    "controller": c,
    "servo": tgy1370a,
    "length": 28,
    "height": height,
  }),
  ("b", "Bumper", "Bx", {
    "depth": 0,
    "height": height,
  }),
  ("l", "Servo", "L", {
    "controller": c,
    "servo": fs90r,
    "shift": 5,
    "center": False,
    "flip": True,
    "width": width,
  }),
  ("r", "Servo", "R", {
    "controller": c,
    "servo": fs90r,
    "shift": 5,
    "center": False,
    "width": width,
  }),
]

devices = [
  ("ld", "LineDetector", 
   "T", 2, "mount", {
     "rotate": True,
   }, {
     "controller": c,
   }),
  ("buzz", "Buzzer", 
   "T", 1, "mount", {
     "rotate": True,
   }, {
     "controller": c,
   }),

  ("led", "LED", 
   None, None, None, {}, {
     "controller": c,
   }),

  ("dist", "DistanceSensor", 
   "L", 0, "mount", {
     "rotate": True,
     "offset": (0, 30)
   }, {
     "controller": c,
     "mount.w": 12.2,
   }),


  ("Mic", "Microphone", 
   "T", 5, "mount", {
     "offset": (0, -40)
   }, {
     "controller": c,
   }),
]

self = Modular(components, devices, 
               brainlen=49, controller=c, 
               yamlFile="test.yaml").getComponent()

self.makeOutput("output/robot1", display=True)
