from svggen.api.component import Component

c = Component()

rows = 2
cols = 8
width = 1.0
gap = 1

c.addSubcomponent("h1","LivingHinge", inherit="rows cols width gap".split(), prefix=None)
c.addSubcomponent("h2","LivingHinge", inherit="rows cols width gap".split(), prefix=None)

c.addSubcomponent("r0","Rectangle", inherit=True, prefix=None)

c.addParameter("angle")

c.addConstraint(("h1","length"), ("w", "rows"), "x[0] * .8 / x[1]")
c.addConstraint(("h1","barheight"), ("w", "rows"), "x[0] * .2 / x[1]")
c.addConstraint(("h1","angle"), "angle")

c.addConstraint(("h2","length"), ("w", "rows"), "x[0] * .8 / x[1]")
c.addConstraint(("h2","barheight"), ("w", "rows"), "x[0] * .2 / x[1]")
c.addConstraint(("h2","angle"), "angle", "-x")

c.addConnection(("h1","leftedge"),("r0","r"))
c.addConnection(("r0","l"), ("h2","rightedge"))

c.inheritInterface("rightedge", ("h1", "rightedge"))
c.inheritInterface("leftedge", ("h2", "leftedge"))

c.toYaml("library/ParallelFlex.yaml")
