from svggen.api.component import Component
from svggen.utils.mymath import tetangle


self = Component()

# Subcomponents used in this assembly
self.addSubcomponent("gripper", "Gripper", inherit=True, prefix=None)
self.addSubcomponent("t", "TBar")
self.addSubcomponent("servo", "MountableServo", inherit=True, prefix=None)

# New free parameters specific to this assembly are added
self.addParameter("length")

self.addConstraint(("gripper", "depth"), "servo","2*x.getParameter('motorwidth')")
self.addConstraint(("gripper", "width"), "depth")
self.addConstConstraint(("gripper", "ratio"), 2)

### Set specific relationships between parameters
self.addConstConstraint(("t", "stemlength"), 6)
self.addConstraint(("t", "leftlength"), ("length", "servo"), "(x[0]-2*x[1].getParameter('motorwidth'))/2.")
self.addConstraint(("t", "rightlength"), ("length", "servo"), "(x[0]-2*x[1].getParameter('motorwidth'))/2.")
self.addConstraint(("t","stemwidth"), "servo","2*x.getParameter('motorwidth')")
#self.addConstraint(("t","crosswidth"), "servo", "x.getParameter('motorlength') + x.getParameter('shoulderlength')*2")
self.addConstraint(("t","crosswidth"), "width")
self.addConstraint(("t", "thickness"), "depth")

angles = [tetangle*x/2 for x in [1,-1,1,-1]]
for i in range(3):
  self.addConnection(("t", "stemedge%d" % i),
                     ("gripper", "botedge%d" % (3-i)), angle=angles[i])

self.addConnection(("t", "topface"),
                   ("servo", "mount"),
                   mode="hole")

for i in range(4):
  self.inheritInterface("topedge%d"%i, ("t", "topedge%d"%i))
  self.inheritInterface("botedge%d"%i, ("t", "botedge%d"%i))
self.inheritInterface("centerface", ("gripper", "face"))
self.inheritInterface("rightface", ("t", "rightface"))
self.inheritInterface("leftface", ("t", "leftface"))
self.inheritAllInterfaces("servo", prefix=None)

self.toYaml("library/MountedGripper.yaml")
