from svggen.api.component import Component
from svggen.utils.Modular import Modular
from svggen.utils.utils import prefix

from svggen.library.Arduino import ArduinoProMini
from svggen.utils.dimensions import tgy1370a, fs90r
c = ArduinoProMini()

height = 12
width = fs90r.getParameter("motorheight")


self = Component("library/Core.yaml")
m = Modular(self, "brain")

cs = [
  ("g", "MountedGripper", "Fx", {
    "controller": c,
    "fingerlength": 50,
    "fingerwidth": 5,
    "servo": tgy1370a,
  }),
  ("br", "RectBeam", "F", {
    "length": 51,
  }),
  ("b", "Bumper", "Bx", {
    "depth": 18,
    "height": height,
  }),
  #("s", "RectBeam", "F"
  ("l", "ServoMount", "L", {
    "servo": fs90r,
    "shift": 5,
    "center": False,
    "flip": True,
    "width": width,
  }),
  ("r", "ServoMount", "R", {
    "servo": fs90r,
    "shift": 5,
    "center": False,
    "width": width,
  }),
]
'''
"controller": c,
"label": "right",
"height": height,
'''

for (name, classname, position, params) in cs:
  m.addComponent(position, (name, classname))

m.make()

self.addConstConstraint(("br", "width"), 50)

self.addSubcomponent("ld", "LineDetector", inherit=True)
self.addConnection(("ld", "mount"), 
                   m.mod["faces"]["Bx"][0])

self.addSubcomponent("td", "TouchSensor", inherit=True)
self.addConnection(("td", "mount"), 
                   m.mod["faces"]["Fx"][0])

self.toYaml("test.yaml")

self.setParameter("brain.length", 49)
self.setParameter('controller', c)
self.setParameter("ld.controller", c)
self.setParameter("td.controller", c)
for (name, _, _, params) in cs:
  for key, value in params.iteritems():
    self.setParameter(prefix(name, key), value)

self.makeOutput("output/seg", display=True)
