
from svggen.api.component import Component

###################
# Component builder
###################

c = Component()

### Subcomponents used in this assembly
c.addSubcomponent("mount", "Header")
c.addSubcomponent("device", "MicrophoneDevice", inherit=False)
c.addSubcomponent("driver", "MicrophoneDriver", inherit=False)
c.addConstConstraint(('driver', 'drivenComponent'), 'device')

c.addConstConstraint(('mount', 'ncols'), 3)
c.addConstConstraint(('mount', 'nrows'), 1)
c.inheritInterface("mount", ("mount", "mount"))

c.addParameter('controller')
c.addParameter('sensorControllerPin')

c.addConstraint(('device', 'sensorSignal.controllerPin'), 'sensorControllerPin')
#
c.addConstraint(('device', 'controller'), 'controller')
c.addConstraint(('driver', 'controller'), 'controller')
#
#
# ### Exposed interfaces
c.inheritInterface("sensorSignal", ("device", "sensorSignal"))
c.inheritInterface("ground", ("device", "ground"))
c.inheritInterface("power", ("device", "power"))
c.inheritInterface("hearNoise", ("driver", "hearNoise"))

c.toYaml("library/Microphone.yaml")

