from svggen.api.component import Component
from svggen.api.Function import Function
from svggen.utils.mymath import sqrt

c = Component()

c.addParameter("height")
c.addParameter("label", "")

c.addSubcomponent("motor", "Servo", inherit=("controller", "length", "depth", "shift", "width", "servo", "center", "flip", "controllerPin"), prefix=None)
c.addConstConstraint(("motor", 'motionType'), 'continuous')
c.addConstConstraint(("motor", 'min'), 0)
c.addConstConstraint(("motor", 'default'), 50)
c.addConstConstraint(("motor", 'max'), 100)
c.addConstConstraint(("motor", 'faces'), range(4))
c.addConstraint(("motor", 'label'), "label", "x + ' drive motor'")

c.addSubcomponent("move", "TwoFourBarLegs", inherit=("flexwidth", "leg.beamwidth", "length", "height", "depth", "width"), prefix=None)
c.addConstraint(("move", "flexlengthx"), "servo", '2*x.getParameter("hornheight")')
c.addConstraint(("move", "dl"), ("length", "servo", "leg.beamwidth", "flexwidth"), 
                                'x[0]/2 - x[2]*%f - x[1].getParameter("rhornlength")-x[3]' % (sqrt(2)/2))

c.addSubcomponent("leg1", "PointedLeg", invert=True)
c.addSubcomponent("leg2", "PointedLeg", invert=True)

c.addConstraint(("leg1", "length"), "height")
c.addConstraint(("leg1", "top"), "depth")
c.addConstraint(("leg1", "beamwidth"), "leg.beamwidth")

c.addConstraint(("leg2", "length"), "height")
c.addConstraint(("leg2", "top"), "depth")
c.addConstraint(("leg2", "beamwidth"), "leg.beamwidth")
c.addConstConstraint(("leg2", "phase"), "True")

c.addConnection(("motor", "slotedge"),
                ("move", "topedge"), angle=0)

c.addConnection(("motor", "botedge3"),
                ("leg1", "top"),
                angle=0)
c.addConnection(("motor", "topedge3"),
                ("leg2", "top"),
                angle=0)

c.inheritAllInterfaces("motor", prefix=None)
c.toYaml("library/LegDrive.yaml")
