from svggen.api.component import Component
from svggen.library.LivingHinge import dxyr

c = Component()

n = 4

width = 1.0
gap = 0
cols = 10
angle = 360./n

dx, dy, r = dxyr(width, gap, cols, angle)
print dx, dy, r

c.addParameter("edge")
c.addParameter("height")

for i in range(n):
    c.addSubcomponent("r%d" % i,"Rectangle")
    c.addConstraint(("r%d" % i,"l"), "edge")
    c.addConstraint(("r%d" % i,"w"), "height")

    c.addSubcomponent("h%d" % i,"LivingHinge")
    c.addConstraint(("h%d" % i,"length"), "height", "x * .9 / 4")
    c.addConstraint(("h%d" % i,"barheight"), "height", "x * .1 / 4")
    c.addConstConstraint(("h%d" % i,"rows"), 4)
    c.addConstConstraint(("h%d" % i,"width"), width)
    c.addConstConstraint(("h%d" % i,"cols"), cols)
    c.addConstConstraint(("h%d" % i,"angle"), angle)
    c.addConstConstraint(("h%d" % i,"gap"), gap)

c.addConstraint(("r%d" % 0,"l"), "edge", "x/2. - 10")
c.addSubcomponent("r%d" % n,"Rectangle")
c.addConstraint(("r%d" % n,"l"), "edge", "x/2. - 10")
c.addConstraint(("r%d" % n,"w"), "height")

for i in range(n):
    c.addConnection(("r%d" % i,"l"),("h%d" % i,"rightedge"))
    c.addConnection(("h%d" % i,"leftedge"),("r%d" % (i+1),"r"))


for s in ("l", "r"):
    c.addSubcomponent("d%s" % s, "Dovetail")

    c.addConstraint(("d%s" % s, "length"), "height")
    c.addConstraint(("d%s" % s, "pitch"), "height", "x/7.")
    c.addConstConstraint(("d%s" % s, "width"), 10)
    c.addConstConstraint(("d%s" % s, "dx"), 0.25)
    c.addConstConstraint(("d%s" % s, "dy"), 0.125)

c.addConnection(("r%d" % n,"l"), ("dl", "rtedge"))
c.addConnection(("r0", "r"), ("dr", "rtedge"))

c.addSubcomponent("bottom", "RegularNGon")
c.addConstConstraint(("bottom", 'n'), n)
c.addConstraint(("bottom", 'radius'), "edge") 

c.addConnection(("r1", "b"), ("bottom", "e0"), angle=90)
c.addConnection(("r2", "b"), ("bottom", "e1"), angle=90)

c.toYaml("library/HexBox.yaml")
