from svggen.api.component import Component
from svggen.api.Function import Function
from svggen.utils.mymath import sqrt, tetangle

c = Component()

c.addSubcomponent("lfinger","Finger")
c.addSubcomponent("rfinger","Finger")
c.addSubcomponent("base","Tetrahedron")
c.addSubcomponent("flat","Rectangle")
c.addSubcomponent("hole1","Cutout")
c.addSubcomponent("hole2","Cutout")

c.addParameter("ratio", 1.5)
c.addParameter("fingerlength")
c.addParameter("fingerwidth")
c.addParameter("width")
c.addParameter("depth")

c.addConstraint(("flat","l"), ("depth", "width", "fingerwidth"), "x[0]+x[1]-x[2]")
c.addConstraint(("flat","w"), "fingerwidth")

c.addConstConstraint(("hole1","d"), 1)
c.addConstConstraint(("hole2","d"), 1)

c.addConstConstraint(("lfinger","shape"), 3)
c.addConstraint(("lfinger","beamwidth"), "fingerwidth")
c.addConstraint(("lfinger","length"), "fingerlength")
c.addConstraint(("lfinger","ratio"), "ratio")
c.addConstConstraint(("lfinger","phase"), 1)

c.addConstConstraint(("rfinger","shape"), 3)
c.addConstraint(("rfinger","beamwidth"), "fingerwidth")
c.addConstraint(("rfinger","length"), "fingerlength")
c.addConstraint(("rfinger","ratio"), "ratio")
c.addConstConstraint(("rfinger","phase"), -3)

c.addConstraint(("base","perimeter"), ("depth", "width"), "sum(x)*2")
c.addConstraint(("base","end"), ("depth", "width"), "(x[1]-x[0]) * 1.0 / sum(x)")
c.addConstraint(("base","start"), ("depth", "width", "fingerwidth"), "(2*x[2]-x[1]-x[0]) * 1.0 / (x[0]+x[1])")

c.addConnection(("lfinger", "botedge"), ("base","startedge2"),angle=10)
c.addConnection(("rfinger", "botedge"), ("base","startedge4"),angle=10)
c.addConnection(("flat", "t"), ("base","startedge3"), angle=90-tetangle/2)
c.addConnection(("flat", "b"), 
                ("base", "startedge1"), 
                angle=90-tetangle/2, tabWidth=Function(
                  params = ("width", "fingerwidth"), 
                  fnstring = "(x[0]-x[1])*%f" % (sqrt(3)/2)
                ))
c.addConnection(("flat", "face"), 
                ("hole1", "hole"),
                offset=Function(
                  params = ("depth", "width", "fingerwidth"), 
                  fnstring = "((x[0]+x[1])/2-x[2], 0)"))
c.addConnection(("flat", "face"), 
                ("hole2", "hole"),
                offset=Function(
                  params = ("depth", "width", "fingerwidth"), 
                  fnstring = "(x[2]-(x[0]+x[1])/2, 0)"))

for i in range(4):
  c.inheritInterface("botedge%d" % i, ("base","endedge%d" % i))
c.inheritInterface("face", ("flat","face"))
c.toYaml("library/Gripper.yaml")
