from svggen.api.component import Component
from svggen.api.Function import Function

c = Component()

c.addParameter("height")

c.addSubcomponent("outside", "RectBeam", inherit=("width", "length", "depth"), prefix=None)
c.addSubcomponent("bot", "Rectangle")
c.addSubcomponent("servomount", "Rectangle")
c.addSubcomponent("inside", "Rectangle")
c.addSubcomponent("fork", "ForkTines", invert=True)
c.addSubcomponent("tab", "Rectangle")
c.addSubcomponent("servo", "MountableServo", inherit=True, prefix=None)

c.addConstConstraint(("outside", "faces"), range(3))

c.addConstraint(("outside", "minlength"), "servo", 'x.getParameter("motorlength") + x.getParameter("shoulderlength")*2')
c.addConstraint(("outside", "mindepth"), "servo", '2*x.getParameter("motorheight")')
c.addConstraint(("outside", "minwidth"), "servo", 'x.getParameter("motorwidth")')

c.addConstraint(("bot", "l"), "length")
c.addConstraint(("bot", "w"), "depth", "x/2.")

c.addConstraint(("servomount", "l"), "length")
c.addConstraint(("servomount", "w"), "width")

c.addConstraint(("inside", "l"), "length")
c.addConstraint(("inside", "w"), "depth", "x/4.")

c.addConstraint(("fork", "width"), "length")
c.addConstraint(("fork", "forkwidth"), "depth", "x/4.")
c.addConstraint(("fork", "forkheight"), ("height", "width"), 'x[0] + x[1]/2.')
c.addConstraint(("fork", "forkdepth"), "length", "x/2.")
c.addConstraint(("fork", "forkinset"), ("length", "servo"), "x[0]/2. - x[1].getParameter('motorlength')/2. + x[1].getParameter('hornoffset')")

c.addConstraint(("tab", "l"), "length")
c.addConstraint(("tab", "w"), "width")

c.addConnection(("outside", "tabedge"),
                ("bot", "t"), angle=90)

c.addConnection(("bot", "b"),
                ("servomount", "t"), angle=90)

c.addConnection(("servomount", "face"),
                ("servo", "mount"), rotate=True)

c.addConnection(("servomount", "b"),
                ("inside", "t"), angle=-90)

c.addConnection(("inside", "b"),
                ("fork", "topedge"), angle=0)

c.addConnection(("fork", "botedge"), 
                ("tab", "t"), angle=-90)

c.addConnection(("tab", "b"),
                ("outside", "slotedge"), 
                angle=180, tabWidth=Function(params="width", fnstring="x"))

c.inheritAllInterfaces("outside", prefix=None)
c.inheritAllInterfaces("servo", prefix=None)

c.toYaml("library/Forklift.yaml")
