from svggen.api.component import Component

c = Component()

c.addParameter("height")
c.addParameter("length")
c.addParameter("depth")
c.addParameter("dl", 0.1)
c.addParameter("width")
c.addParameter("flip")

c.addSubcomponent("stick", "Rectangle")
c.addSubcomponent("foil","Wing")
c.addSubcomponent("split","SplitEdge")

c.addConstraint(("split","botlength"), ("length", "depth"), "[sum(x)]")
c.addConstraint(("split","toplength"), ("length", "depth"), "[x[0]/2., x[1], x[0]/2.]")

c.addConstraint(("stick","l"), "height")
c.addConstraint(("stick","w"), "depth")

c.addConstraint(("foil","bodylength"), "depth")
c.addConstraint(("foil","wingtip"), "depth")
c.addConstraint(("foil","thickness"), ("dl", "depth"), "x[0] * x[1]")
c.addConstraint(("foil","wingspan"), "width")
c.addConstraint(("foil","flip"), "flip")


c.addConnection(("split", "topedge1"), ("stick", "l"))
c.addConnection(("stick", "r"), ("foil", "tip"), angle=90)


c.inheritInterface("mount", ("split", "botedge0"))
c.inheritInterface("join", ("foil", "base"))

c.toYaml("library/Foil.yaml")
