from svggen.api.component import Component

c = Component()

c.addSubcomponent("h","ParallelFlex", inherit=True, prefix=None)
c.addSubcomponent("r","Rectangle", inherit="w", prefix=None)
c.addSubcomponent("s","SplitEdge")

c.addParameter("rw", 1)
c.addParameter("lw", 1)

c.addConstraint(("r","l"), ("w", "rw", "lw"), "x[0] * (1+x[1]+x[2])")
c.addConstraint(("s","toplength"), ("w", "rw", "lw"), "[x[0] * (1+x[1]+x[2]) ]")
c.addConstraint(("s","botlength"), ("w", "rw", "lw"), "[x[0]*x[1], x[0], x[0]*x[2]]")

c.addConnection(("h", "rightedge"), ("s","botedge1"))
c.addConnection(("s","topedge0"), ("r","b"))

c.inheritInterface("legedge", ("h", "leftedge"))
c.inheritInterface("baredge", ("r", "t"))
c.inheritInterface("leftedge", ("s", "botedge2"))
c.inheritInterface("rightedge", ("s", "botedge0"))

c.toYaml("library/FlexLeg.yaml")
