from svggen.api.component import Component
from svggen.api.Function import Function

self = Component()

self.addSubcomponent("prox","Beam")
self.addSubcomponent("dist","Beam")
self.addSubcomponent("ext","Extension")
self.addSubcomponent("hole","Cutout")

self.addConstConstraint(("hole","d"), 1)

self.addParameter("ratio")
self.addParameter("length")
self.addParameter("beamwidth")
self.addParameter("shape", 3)
self.addParameter("phase", 0)

self.addConstraint(("prox","length"),("ratio", "length"), "x[1]/(1+x[0])")
self.addConstConstraint(("prox","tangle"), 60)
self.addConstConstraint(("prox","bangle"), -90)
self.addConstraint(("prox","beamwidth"), "beamwidth")
self.addConstraint(("prox","shape"), "shape")
self.addConstraint(("prox","phase"), "phase")

self.addConstraint(("dist","length"),("ratio", "length"), "x[1] * x[0]/(1+x[0])")
self.addConstConstraint(("dist","tangle"), 30)
self.addConstConstraint(("dist","bangle"), 60)
self.addConstraint(("dist","beamwidth"), "beamwidth")
self.addConstraint(("dist","shape"), "shape")
self.addConstraint(("dist","phase"), "phase")

self.addConstraint(("ext","w"), "beamwidth")
self.addConstraint(("ext","l"), "beamwidth")

self.addConnection(("ext", "t"), ("prox","botedge"),angle=180)
self.addConnection(("prox", "topedge"), ("dist","botedge"),angle=60)

'''
self.addConnection(("dist", "face0"),
                   ("hole", "hole"),
                   offset=Function(
                     params = ("ratio", "length", "beamwidth"),
                     fnstring = "(0, -(x[1] * x[0]/(1+x[0]) - x[2])/2.)"))
'''

self.inheritInterface("botedge",("ext","b"))

self.toYaml("library/Finger.yaml")
