from svggen.api.component import Component

c = Component(yamlFile="library/SegBase.yaml")

c.addSubcomponent("gripper", "MountedGripper", inherit=("controller", "depth"), prefix=None, invert=True)

c.addParameter("gripperservo")
c.addConstraint(("gripper", "servo"), "gripperservo")
c.addConstraint(("gripper", "length"), "width")

c.addConstConstraint(("gripper","fingerlength"), 30)
c.addConstConstraint(("gripper","fingerwidth"), 6)

c.addConnection(("left", "botedge2"),
                ("gripper", "topedge2"),
                angle=90)
c.addConnection(("gripper", "botedge2"),
                ("right", "topedge2"),
                angle=90, tabWidth=10)

c.toYaml("library/FetchSeg.yaml")

