from svggen.api.component import Component

c = Component()

c.addParameter("l")
c.addParameter("w")

c.addSubcomponent("top", "Rectangle")
c.addSubcomponent("bot", "Rectangle")

c.addConstraint(("top", "l"), "w")
c.addConstraint(("top", "w"), "l", "x/2")

c.addConstraint(("bot", "l"), "w")
c.addConstraint(("bot", "w"), "l", "x/2")

c.addConnection(("top", "b"),
                ("bot", "t"), angle=180)

c.inheritInterface("t", ("top", "t"))
c.inheritInterface("b", ("bot", "b"))

c.toYaml("library/Extension.yaml")
