from svggen.api.component import Component
from svggen.api.Function import Function

c = Component()

c.addParameter("length")
c.addParameter("width")
c.addParameter("height")

c.addParameter("controller")
c.addParameter("driveservo")

c.addSubcomponent("brain", "ESPBrains")
c.addSubcomponent("right", "Servo", invert=True)
c.addSubcomponent("left", "Servo", invert=True)

# Constant thickness of main body
def depthfn(params = None, fnmod = None):
    if params is None: params = []
    if fnmod is None: fnmod = "%s"
    return ["controller", "driveservo"] + params, \
            fnmod % "max(x[0].getDimension('height'), x[1].getParameter('motorwidth'))"

# Set microcontroller
c.addConstraint(("brain","depth"), *depthfn())
c.addConstraint(("brain","length"), "width")
c.addConstraint(("brain", "brain"), "controller")

for servo in ("right", "left"):
    c.addConstraint((servo,"depth"), *depthfn())
    c.addConstraint((servo, "length"), 
                    ("length", "controller"), 
                    "x[0] - x[1].getDimension('width')")
    c.addConstConstraint((servo, "center"), False)

    c.addConstraint((servo, "servo"), "driveservo")
    c.addConstraint((servo, "controller"), "controller")
    c.addConstConstraint((servo, 'motionType'), 'continuous')
    c.addConstConstraint((servo, 'label'), servo + ' wheel')

    c.addConstConstraint((servo, 'min'), -50)
    c.addConstConstraint((servo, 'default'), 0)
    c.addConstConstraint((servo, 'max'), 50)

c.addConstConstraint(("left","phase"), 2)

# connections
c.addConnection(("brain", "topedge0"),
                ("right", "topedge2"),
                angle=-90)
c.addConnection(("brain", "botedge0"),
                ("left", "topedge0"),
                angle=-90)

# Sheath 
c.addParameter("battery")

c.addSubcomponent("sheath", "RectBeam")
c.addConstConstraint(("sheath","phase"), 1)
c.addConstraint(("sheath","length"), "length")
c.addConstraint(("sheath","width"), "width")
c.addConstraint(("sheath","depth"), *depthfn(["battery"], "%s + x[2]"))

c.addSubcomponent("sheathsplit", "SplitEdge")
c.addConstraint(("sheathsplit","toplength"), "width", "(x,)")
c.addConstraint(("sheathsplit","botlength"), ("driveservo", "width"), 
        "(x[0].getParameter('motorheight'), \
          x[1] - 2*x[0].getParameter('motorheight'), \
          x[0].getParameter('motorheight'))")

c.addConnection(("left", "botedge1"),
                ("sheathsplit", "botedge2"),
                angle=180)

'''
c.addConnection(("right", "botedge1"),
                ("sheathsplit", "botedge0"),
                angle=180, tabWidth=40)
'''

c.addConnection(("sheathsplit", "topedge0"),
                ("sheath", "topedge1"))

# Tail
c.addSubcomponent("tail", "Tail", inherit=("flapwidth", "tailwidth"), prefix=None)
c.addConstraint(("tail","width"), "width")
c.addConstraint(("tail","height"), *depthfn(["height"], "%s/2.+x[2]"))
c.addConstraint(("tail","depth"), *depthfn(["battery"], "%s+x[2]"))

c.addConnection(("tail", "topedge"),
                ("sheath", "botedge1"),
                angle=90)

c.addSubcomponent("tailsplit", "SplitEdge")
c.addConstraint(("tailsplit","toplength"), "width", "(x,)")
c.addConstraint(("tailsplit","botlength"), ("width", "flapwidth"), "(x[0]*(1-x[1])/2., x[0]*x[1], x[0]*(1-x[1])/2.)")

c.addConnection(("sheath", "botedge3"),
                ("tailsplit", "topedge0"))

c.addConnection(("tail", "flapedge"),
                ("tailsplit", "botedge1"),
                angle=90, tabWidth=Function(*depthfn(["battery"], "%s+x[2]")))

# USB charging port for battery
c.addSubcomponent("usb", "Cutout")
c.addConstConstraint(("usb", "dy"), 9)
c.addConstConstraint(("usb", "dx"), 4)

c.addConnection(("sheath", "face1"),
                ("usb", "hole"),
                mode="hole",
                offset=Function(*depthfn(["length", "battery"], "(4-(%s+x[3])/2, 0.5 * x[2] - 15)")))

'''
# Add new UI control for both wheels simultaneously
c.addSubcomponent('slider', 'UISlider', inherit="controller", prefix=None)
c.addConnection(('slider', 'curPosition'),
                ('right', 'servoControl'))
c.addConnection(('slider', 'curPosition'),
                ('left', 'servoControl'))
c.addConstConstraint(('slider', 'min'), -50)
c.addConstConstraint(('slider', 'default'), 0)
c.addConstConstraint(('slider', 'max'), 50)
c.addConstConstraint(('slider', 'label'), 'Both Wheels')

# Add bluetooth module
c.addSubcomponent('bluetooth', 'BluetoothModule', inherit="controller", prefix=None)
c.addConstConstraint(("bluetooth", 'RX.controllerPin'), 10) # optional, will auto-connect if omitted
c.addConstConstraint(("bluetooth", 'TX.controllerPin'), 11) # optional, will auto-connect if omitted

# Set servo pins
c.addConstConstraint(("right","controllerPin"), 3)
c.addConstConstraint(("left","controllerPin"), 9)
'''

for i in range(6):
    wheel = "wheel%d"%i
    c.addSubcomponent(wheel, "RegularNGon")
    c.addConstConstraint((wheel, 'n'), 40)
    c.addConstraint((wheel, 'radius'), "height")

    c.addSubcomponent(wheel+"hole", "Cutout")
    c.addConstConstraint((wheel+"hole", 'd'), 1)
    c.addConnection((wheel, "face"),
                    (wheel+"hole", "hole"),
                    mode="hole")

c.toYaml("library/ESPSeg.yaml")
