from svggen.api.component import Component
from svggen.api.Function import Function

c = Component()

c.addParameter("length")
c.addParameter("width")
c.addParameter("height")

c.addParameter("controller")
c.addParameter("driveservo")

c.addSubcomponent("brain", "ESPBrains")
c.addSubcomponent("right", "ServoMount", invert=True)
c.addSubcomponent("left", "ServoMount", invert=True)

# Constant thickness of main body
def depthfn(params = None, fnmod = None):
    if params is None: params = []
    if fnmod is None: fnmod = "%s"
    return ["controller", "driveservo"] + params, \
            fnmod % "max(x[0].getDimension('height'), x[1].getParameter('motorwidth'))"

# Set microcontroller
c.addConstraint(("brain","depth"), *depthfn())
c.addConstraint(("brain","length"), "width")
c.addConstraint(("brain", "brain"), "controller")

for servo in ("right", "left"):
    c.addConstraint((servo,"depth"), *depthfn())
    c.addConstraint((servo, "length"), 
                    ("length", "controller"), 
                    "x[0] - x[1].getDimension('width')")
    c.addConstConstraint((servo, "center"), False)

    c.addConstraint((servo, "servo"), "driveservo")

c.addConstConstraint(("left","phase"), 2)

# connections
c.addConnection(("brain", "topedge0"),
                ("right", "topedge2"),
                angle=-90)
c.addConnection(("brain", "botedge0"),
                ("left", "topedge0"),
                angle=-90)

# Sheath 
c.addParameter("battery")

c.addSubcomponent("sheath", "RectBeam")
c.addConstConstraint(("sheath","phase"), 1)
c.addConstraint(("sheath","length"), "length")
c.addConstraint(("sheath","width"), "width")
c.addConstraint(("sheath","depth"), *depthfn(["battery"], "%s + x[2]"))

c.addSubcomponent("sheathsplit", "SplitEdge")
c.addConstraint(("sheathsplit","toplength"), "width", "(x,)")
c.addConstraint(("sheathsplit","botlength"), ("driveservo", "width"), 
        "(x[0].getParameter('motorheight'), \
          x[1] - 2*x[0].getParameter('motorheight'), \
          x[0].getParameter('motorheight'))")

c.addConnection(("left", "botedge1"),
                ("sheathsplit", "botedge2"),
                angle=180)

c.addConnection(("sheathsplit", "topedge0"),
                ("sheath", "topedge1"))

# USB charging port for battery
c.addSubcomponent("usb", "Cutout")
c.addConstConstraint(("usb", "dy"), 9)
c.addConstConstraint(("usb", "dx"), 4)

c.addConnection(("sheath", "face1"),
                ("usb", "hole"),
                mode="hole",
                offset=Function(*depthfn(["length", "battery"], "(4-(%s+x[3])/2, 0.5 * x[2] - 15)")))

c.toYaml("library/ESPCore.yaml")
