from svggen.api.component import Component
from svggen.api.Function import Function


self = Component()

self.addSubcomponent("beam", "RectBeam")
self.addSubcomponent("header", "Header")
self.addSubcomponent("servoPins", "Cutout")

self.addParameter("brain")
self.addParameter("length")
self.addParameter("width", 0)
self.addParameter("depth", 0)

### Set specific relationships between parameters
def getBrainParameter(p):
  return "brain", "x.getDimension('%s')" % p

self.addConstraint(("beam", "width"), "depth")
self.addConstraint(("beam", "depth"), "width")
self.addConstraint(("beam", "length"), "length")

self.addConstraint(("beam", "minwidth"), *getBrainParameter("height"))
self.addConstraint(("beam", "mindepth"), *getBrainParameter("width"))
self.addConstraint(("beam", "minlength"), *getBrainParameter("length"))

self.addConstraint(("header", "nrows"), *getBrainParameter("nrows"))
self.addConstraint(("header", "ncols"), *getBrainParameter("ncols"))
self.addConstraint(("header", "rowsep"), *getBrainParameter("rowsep"))
self.addConstraint(("header", "colsep"), *getBrainParameter("colsep"))

self.addConstConstraint(("servoPins", "dy"), 8)
self.addConstConstraint(("servoPins", "dx"), 27)

self.addConnection(("beam", "face1"),
                   ("header", "mount"),
                   mode="hole", offset=Function(params=("length", "brain"), fnstring="(7.5, -4.5 + 0.5*(x[0]-x[1].getDimension('length')))"))

self.addConnection(("beam", "face1"),
                   ("servoPins", "hole"),
                   mode="hole", rotate=True, offset=Function(params=("length", "brain"), fnstring="(-17.25, (0.5 * (x[0]-x[1].getDimension('length')))-14)"))

self.inheritAllInterfaces("beam", prefix=None)

self.toYaml("library/ESPBrains.yaml")
