from svggen.api.component import Component
from svggen.api.Function import Function


self = Component()

# Subcomponents used in this assembly
self.addSubcomponent("left", "Wing", inherit=True, prefix=None)
self.addSubcomponent("lmotor", "DeltaMotor", inherit=True, prefix=None)
self.addSubcomponent("body", "Wing", inherit="bodylength thickness".split(), prefix=None)
self.addSubcomponent("rmotor", "DeltaMotor", inherit=True, prefix=None)
self.addSubcomponent("right", "Wing", inherit=True, prefix=None)

# New free parameters specific to this assembly are added
self.addParameter("bodywidth")

### Set specific relationships between parameters
self.addConstConstraint(("right", "flip"), True)

self.addConstraint(("body", "wingtip"), "bodylength")
self.addConstraint(("body", "wingspan"), "bodywidth")

self.addConnection(("left", "base"),
                   ("lmotor", "l"), angle=0)
self.addConnection(("lmotor", "r"),
                   ("body", "tip"), angle=0)
self.addConnection(("body", "base"),
                   ("rmotor", "l"), angle=0)
self.addConnection(("rmotor", "r"),
                   ("right", "base"), angle=0)

self.toYaml("library/Delta.yaml")
