from svggen.api.component import Component
from svggen.api.Function import Function


self = Component()

# Subcomponents used in this assembly
self.addSubcomponent("left", "Wing", inherit=True, prefix=None)
self.addSubcomponent("body", "Wing", inherit="bodylength thickness".split(), prefix=None)
self.addSubcomponent("right", "Wing", inherit=True, prefix=None)

self.addSubcomponent("m11", "Cutout")
self.addSubcomponent("m12", "Cutout")
self.addSubcomponent("m21", "Cutout")
self.addSubcomponent("m22", "Cutout")

self.addSubcomponent("header", "Header")

# New free parameters specific to this assembly are added
self.addParameter("bodywidth")

### Set specific relationships between parameters
self.addConstConstraint(("right", "flip"), True)

self.addConstConstraint(("m11", "dx"), 2.0)
self.addConstConstraint(("m12", "dx"), 2.0)
self.addConstConstraint(("m21", "dx"), 2.0)
self.addConstConstraint(("m22", "dx"), 2.0)

self.addConstConstraint(("m11", "dy"), 12)
self.addConstConstraint(("m12", "dy"), 12)
self.addConstConstraint(("m21", "dy"), 12)
self.addConstConstraint(("m22", "dy"), 12)

self.addConstConstraint(("header", "nrows"), 10)
self.addConstConstraint(("header", "ncols"), 2)
self.addConstConstraint(("header", "rowsep"), 2)
self.addConstConstraint(("header", "colsep"), 22)

self.addConstraint(("body", "wingtip"), "bodylength")
self.addConstraint(("body", "wingspan"), "bodywidth")

self.addConnection(("left", "base"),
                   ("body", "tip"), angle=0)
self.addConnection(("body", "base"),
                   ("right", "base"), angle=0)

self.addConnection(("left", "basetop"),
                   ("body", "tiptop"), angle=0, tabWidth=10)
self.addConnection(("right", "basetop"), 
                   ("body", "basetop"), angle=0, tabWidth=10)

self.addConnection(("left", "bottom"),
                   ("m11", "hole"), 
                   offset = Function(
                       params=("wingspan", "wingtip", "bodylength"),
                       fnstring="(x[0]/2., (x[1]+x[2])/2.-6)"))
self.addConnection(("left", "bottom"),
                   ("m12", "hole"), 
                   offset = Function(
                       params=("wingspan", "wingtip", "bodylength"),
                       fnstring="(x[0]/2.+6, (x[1]+x[2])/2.-6)"))

self.addConnection(("right", "bottom"),
                   ("m21", "hole"), 
                   offset = Function(
                       params=("wingspan", "wingtip", "bodylength"),
                       fnstring="(x[0]/2.-6, (x[1]+x[2])/2.-6)"))
self.addConnection(("right", "bottom"),
                   ("m22", "hole"), 
                   offset = Function(
                       params=("wingspan", "wingtip", "bodylength"),
                       fnstring="(x[0]/2., (x[1]+x[2])/2.-6)"))

self.addConnection(("body", "bottom"),
                   ("header", "mount"), 
                   offset = Function(
                       params=("bodywidth", "bodylength"),
                       fnstring="(x[0]/2., x[1]/2.)"))

self.toYaml("library/Delta.yaml")
