from svggen.api.component import Component

c = Component()

c.addParameter("controller")

c.addSubcomponent("brain", "Brains", inherit=True)
c.delParameter("brain.brain")
c.addConstraint(("brain", "brain"), "controller")

# Add bluetooth module
c.addSubcomponent('bluetooth', 'BluetoothModule', inherit="controller", prefix=None)
c.addConstConstraint(("bluetooth", 'RX.controllerPin'), 10) # optional, will auto-connect if omitted
c.addConstConstraint(("bluetooth", 'TX.controllerPin'), 11) # optional, will auto-connect if omitted

c.addSubcomponent('fsm', 'StateMachine', inherit=True, prefix=None)

c.toYaml("library/Core.yaml")
