from svggen.api.component import Component

###################
# Component builder
###################

c = Component()
c.addSubcomponent("servo", "EServo", inherit=True, prefix=None)
c.addSubcomponent('dataFunction', 'DataFunction', inherit="controller", prefix=None)
c.addSubcomponent("mount", "Cutout")

c.addParameter("servo")
c.addParameter("flip", False)
c.addConstraint(('dataFunction', 'function'), 'flip', "'input' + (x and '*-1' or '')")

c.addConstraint(("mount", "dx"), "servo", 'x.getParameter("motorwidth") * 0.99')
c.addConstraint(("mount", "dy"), "servo", 'x.getParameter("motorlength")')

c.addConnection(('servo', 'control'),
                ('dataFunction', 'output'))

c.inheritInterface('control', ('dataFunction', 'input'))
c.inheritInterface('signal', ('servo', 'signal'))
c.inheritInterface('power', ('servo', 'power'))
c.inheritInterface('ground', ('servo', 'ground'))
c.inheritInterface("mount", ("mount", "hole"))
c.toYaml("library/MountableServo.yaml")

c = Component()

c.addSubcomponent("servo", "EServo", inherit=True, prefix=None)
c.addSubcomponent('dataFunction', 'DataFunction', inherit="controller", prefix=None)
c.addSubcomponent("mount", "ServoMount", inherit=True, prefix=None)

c.addConstraint(('dataFunction', 'function'), 'flip', "'input' + (x and '*-1' or '')")

c.addConnection(('servo', 'control'),
                ('dataFunction', 'output'))

c.inheritInterface('control', ('dataFunction', 'input'))
c.inheritInterface('signal', ('servo', 'signal'))
c.inheritInterface('power', ('servo', 'power'))
c.inheritInterface('ground', ('servo', 'ground'))
c.inheritAllInterfaces("mount", prefix=None)
c.toYaml("library/MountedServo.yaml")

c = Component()
### Subcomponents used in this assembly
c.addSubcomponent("servo", "MountedServo", inherit=True, prefix=None)
c.addSubcomponent("slider", "UISlider", inherit=True, prefix=None)

c.addConnection(('servo', 'control'),
                ('slider', 'curPosition'))

c.inheritAllInterfaces("servo", prefix=None)
c.interfaces.pop('control')
c.inheritInterface('servoControl', ('servo', 'control'))
c.toYaml("library/Servo.yaml")

c = Component()
