from svggen.api.component import Component

c = Component()

c.addSubcomponent("seat","ChairPanel", inherit=True, prefix=None)
c.addSubcomponent("back","ChairBack", inherit=True, prefix=None)
c.addSubcomponent("kitel","Kite", inherit="thickness", prefix=None)
c.addSubcomponent("kiter","Kite", inherit="thickness", prefix=None)

c.addParameter("recline", 110, paramtype="angle")

c.addConstraint(("kitel","angle"), "recline", "180 - x")
c.addConstraint(("kiter","angle"), "recline", "180 - x")

c.addConnection(("back","left"),("kitel","t"), angle=0)
c.addConnection(("seat","bl"),("kitel","b"), angle=0)

c.addConnection(("back","right"),("kiter","b"), angle=0)
c.addConnection(("seat","br"),("kiter","t"), angle=0)

c.inheritInterface("right", ("seat", "right"))
c.inheritInterface("left", ("seat", "left"))

c.toYaml("library/ChairSeat.yaml")
