from svggen.api.component import Component

c = Component()

c.addSubcomponent("back","Rectangle")
c.addSubcomponent("sidel","Rectangle")
c.addSubcomponent("sider","Rectangle")

c.addParameter("depth", 50, paramtype="length")
c.addParameter("width", 70, paramtype="length")
c.addParameter("thickness", 10, paramtype="length")

c.addConstraint(("back","l"), "width")
c.addConstraint(("back","w"), "depth")

c.addConstraint(("sidel","l"), "thickness")
c.addConstraint(("sidel","w"), "depth")
c.addConstraint(("sider","l"), "thickness")
c.addConstraint(("sider","w"), "depth")

c.addConnection(("sidel","r"),("back","l"), angle=90)
c.addConnection(("back","r"),("sider","l"), angle=90)

c.inheritInterface("tr", ("sider", "t"))
c.inheritInterface("tl", ("sidel", "t"))
c.inheritInterface("br", ("sider", "b"))
c.inheritInterface("bl", ("sidel", "b"))
c.inheritInterface("right", ("sider", "r"))
c.inheritInterface("left", ("sidel", "l"))

c.toYaml("library/ChairPanel.yaml")
