from svggen.api.component import Component
from svggen.library.LivingHinge import dxy

c = Component()

width = 1.0
gap = .5
cols = 12
angle = 90

dx, dy = dxy(width, gap, cols, angle)

c.addSubcomponent("h1","LivingHinge")
c.addSubcomponent("h2","LivingHinge")

c.addSubcomponent("r0","Rectangle")
c.addSubcomponent("r1","Rectangle")
c.addSubcomponent("r2","Rectangle")
c.addSubcomponent("r3","Rectangle")
c.addSubcomponent("r4","Rectangle")
c.addSubcomponent("back","Rectangle")

c.addParameter("width")
c.addParameter("depth")

c.addConstraint(("r0","w"), "width")
c.addConstraint(("r1","w"), "width")
c.addConstraint(("r2","w"), "width")
c.addConstraint(("r3","w"), "width")
c.addConstraint(("r4","w"), "width")
c.addConstraint(("r0","l"), "depth", "x/3.")
c.addConstraint(("r1","l"), "depth", "x/3.")
c.addConstraint(("r2","l"), "depth", "x/3.")
c.addConstraint(("r3","l"), "depth", "x/3.")
c.addConstraint(("r4","l"), "depth", "x/3.")

c.addConstraint(("back","w"), "width")
c.addConstraint(("back","l"), "width")

c.addConstraint(("h1","length"), "width", "x * .8 / 4")
c.addConstraint(("h1","barheight"), "width", "x * .1 / 4")
c.addConstConstraint(("h1","rows"), 4)
c.addConstConstraint(("h1","width"), width)
c.addConstConstraint(("h1","cols"), cols)
c.addConstConstraint(("h1","angle"), angle)
c.addConstConstraint(("h1","gap"), gap)

c.addConstraint(("h2","length"), "width", "x * .8 / 4")
c.addConstraint(("h2","barheight"), "width", "x * .1 / 4")
c.addConstConstraint(("h2","rows"), 4)
c.addConstConstraint(("h2","width"), width)
c.addConstConstraint(("h2","cols"), cols)
c.addConstConstraint(("h2","angle"), -angle)
c.addConstConstraint(("h2","gap"), gap)

c.addConnection(("back","l"),("r0","r"))
c.addConnection(("r0","l"),("h1","rightedge"))
c.addConnection(("h1","leftedge"),("r1","r"))
c.addConnection(("r1","l"),("r2","r"))
c.addConnection(("r2","l"),("r3","r"))
c.addConnection(("r3","l"),("h2","rightedge"))
c.addConnection(("h2","leftedge"),("r4","r"))

c.addSubcomponent("a1","Rectangle")
c.addSubcomponent("a2","Rectangle")
c.addSubcomponent("a3","Rectangle")

c.addConstraint(("a1","l"), "depth", "x * 2. / 3 + " + str(dx))
c.addConstConstraint(("a2","l"), dy)
c.addConstraint(("a1","w"), "depth", "x/3.")
c.addConstraint(("a2","w"), "depth", "x/3.")
c.addConstraint(("a3","w"), "depth", "x/3.")
c.addConstraint(("a3","l"), "depth", "x/3.")

c.addConnection(("r0","b"),("a1","l"), angle=90)
c.addConnection(("r3","b"),("a2","l"), angle=90)
c.addConnection(("a1","r"),("a3","t"))
c.addConnection(("a2","r"),("a3","l"))

c.toYaml("library/Chair.yaml")
