from svggen.api.component import Component

c = Component()

c.addSubcomponent("panel","ChairPanel", inherit=("width", "thickness"), prefix=None)

c.addParameter("gapheight", 20, paramtype="length")
c.addParameter("backheight", 40, paramtype="length")

c.addConstraint(("panel","depth"), "backheight")

c.addSubcomponent("sider","Rectangle")
c.addConstraint(("sider","l"), "thickness")
c.addConstraint(("sider","w"), "gapheight")
c.addConnection(("panel","tr"),("sider","t"), angle=0)
c.inheritInterface("right", ("sider", "b"))

c.addSubcomponent("sidel","Rectangle")
c.addConstraint(("sidel","l"), "thickness")
c.addConstraint(("sidel","w"), "gapheight")
c.addConnection(("panel","tl"),("sidel","t"), angle=0)
c.inheritInterface("left", ("sidel", "b"))

c.toYaml("library/ChairBack.yaml")
