from svggen.api.component import Component

c = Component()

# BOX

c.addSubcomponent("boat","Catamaran", inherit=True, prefix=None)
c.addSubcomponent("port","Foil", inherit=True, prefix=None)
c.addSubcomponent("star","Foil", inherit=True, prefix=None)

c.delParameter("flip")

c.addConstraint(("port","width"), "width", "x/4.")
c.addConstraint(("port","height"), ("length", "depth"), "sum(x)/3.")
c.addConstConstraint(("port","flip"), True)

c.addConstraint(("star","width"), "width", "x/4.")
c.addConstraint(("star","height"), ("length", "depth"), "sum(x)/3.")
c.addConstConstraint(("star","flip"), False)

c.addConnection(("boat", "portedge"), ("port", "mount"), angle=-180)
c.addConnection(("boat", "staredge"), ("star", "mount"), angle=-180)
c.addConnection(("star", "join"), ("port", "join"), tabWidth=10)

c.toYaml("library/CatFoil.yaml")
