from svggen.api.component import Component

c = Component()

# BOX

c.addSubcomponent("cabin","Cabin", inherit=True, prefix=None)
c.addSubcomponent("port","BoatBase")
c.addSubcomponent("star","BoatBase")

c.addConstraint(("port","length"), ("length", "depth"), "sum(x)")
c.addConstraint(("port","width"), "width", "x/4.")
c.addConstraint(("port","depth"), ("length", "depth"), "sum(x)/20.")
c.addConstraint(("port","bow"), "length", "x/2.")
c.addConstraint(("port","stern"), "length", "x/8.")

c.addConstraint(("star","length"), ("length", "depth"), "sum(x)")
c.addConstraint(("star","width"), "width", "x/4.")
c.addConstraint(("star","depth"), ("length", "depth"), "sum(x)/20.")
c.addConstraint(("star","bow"), "length", "x/2.")
c.addConstraint(("star","stern"), "length", "x/8.")

c.addConnection(("cabin", "portedge"), ("port", "portedge"))
c.addConnection(("cabin", "staredge"), ("star", "staredge"))

c.inheritInterface("foreedge", ("cabin", "foreedge"))
c.inheritInterface("rearedge", ("cabin", "rearedge"))
c.inheritInterface("portedge", ("port", "staredge"))
c.inheritInterface("staredge", ("star", "portedge"))

c.toYaml("library/Catamaran.yaml")
