from svggen.api.component import Component

c = Component()

# BOX

c.addSubcomponent("boat","BoatBase", inherit=True, prefix=None)

c.addParameter("n", 3)

c.addSubcomponent("portsplit","SplitEdge")
c.addSubcomponent("starsplit","SplitEdge")

c.addConstraint(("portsplit","botlength"), ("length", "n"), "[x[0]]")
c.addConstraint(("portsplit","toplength"), ("length", "n"), "[x[0]/(2.*x[1]+1.)] * (2*x[1]+1)")
c.addConstraint(("starsplit","toplength"), ("length", "n"), "[x[0]]")
c.addConstraint(("starsplit","botlength"), ("length", "n"), "[x[0]/(2.*x[1]+1.)] * (2*x[1]+1)")

c.addConnection(("portsplit", "botedge0"), ("boat", "portedge"), angle=90)
c.addConnection(("starsplit", "topedge0"), ("boat", "staredge"), angle=90, tabWidth=10)

for i in range(10):
    nm = "seat%d"%i
    c.addSubcomponent(nm, "Rectangle")
    c.addConstraint((nm, "l"), ("width", "n"), "(%d < x[1]) and x[0] or 0" % i)
    c.addConstraint((nm, "w"), ("length", "n"), "x[0]/(2.*x[1]+1.)")
    c.addConnection(("portsplit", "topedge%d" % (2*i+1)), (nm, "l"))
    c.addConnection(("starsplit", "botedge%d" % (2*i+1)), (nm, "r"))
c.toYaml("library/Canoe.yaml")
