from svggen.api.component import Component

c = Component()

# BOX

c.addParameter("depth", 50)
c.addParameter("width", 60)
c.addParameter("height", 30)

c.addSubcomponent("top","Rectangle")
c.addSubcomponent("fore","Rectangle")
c.addSubcomponent("rear","Rectangle")
c.addSubcomponent("port","Rectangle")
c.addSubcomponent("star","Rectangle")

c.addConstraint(("top","w"), "depth")
c.addConstraint(("top","l"), "width")

c.addConstraint(("fore","w"), "height")
c.addConstraint(("fore","l"), "width")
c.addConstraint(("rear","w"), "height")
c.addConstraint(("rear","l"), "width")

c.addConnection(("rear", "t"), ("top", "b"), angle=90)
c.addConnection(("top", "t"), ("fore", "b"), angle=90)

c.addConstraint(("port","w"), "depth")
c.addConstraint(("port","l"), "height")
c.addConstraint(("star","w"), "depth")
c.addConstraint(("star","l"), "height")

c.addConnection(("port", "r"), ("top", "l"), angle=90)
c.addConnection(("top", "r"), ("star", "l"), angle=90)

c.addConnection(("port", "t"), ("fore", "l"), angle=90, tabWidth=10)
c.addConnection(("fore", "r"), ("star", "t"), angle=90, tabWidth=10)
c.addConnection(("star", "b"), ("rear", "r"), angle=90, tabWidth=10)
c.addConnection(("rear", "l"), ("port", "b"), angle=90, tabWidth=10)

# Interface to floats

c.addParameter("length", 200)

c.addSubcomponent("portsplit","SplitEdge")
c.addSubcomponent("starsplit","SplitEdge")

c.addConstraint(("portsplit","botlength"), ("length", "depth"), "[sum(x)]")
c.addConstraint(("portsplit","toplength"), ("length", "depth"), "[x[0]/2., x[1], x[0]/2.]")
c.addConnection(("portsplit", "topedge1"), ("port", "l"))

c.addConstraint(("starsplit","botlength"), ("length", "depth"), "[sum(x)]")
c.addConstraint(("starsplit","toplength"), ("length", "depth"), "[x[0]/2., x[1], x[0]/2.]")
c.addConnection(("starsplit", "topedge1"), ("star", "r"))

c.inheritInterface("portedge", ("portsplit", "botedge0"))
c.inheritInterface("staredge", ("starsplit", "botedge0"))
c.inheritInterface("foreedge", ("fore", "t"))
c.inheritInterface("rearedge", ("rear", "b"))

c.toYaml("library/Cabin.yaml")
