
from svggen.api.component import Component

###################
# Component builder
###################

c = Component()

### Subcomponents used in this assembly
c.addSubcomponent("mount", "Header", inherit=False)
c.addSubcomponent("device", "BuzzerDevice", inherit=False)
c.addSubcomponent("driver", "BuzzerDriver", inherit=False)
c.addConstConstraint(('driver', 'drivenComponent'), 'device')

c.addConstConstraint(('mount', 'ncols'), 2)
c.addConstConstraint(('mount', 'nrows'), 1)
c.addConstConstraint(('mount', 'colsep'), 3*2.54)
c.inheritInterface("mount", ("mount", "mount"))

c.addParameter('controller')
c.addParameter('controllerPin')
c.addParameter('autoPoll')

c.addConstraint(('device', 'signal.controllerPin'), 'controllerPin')
c.addConstraint(('device', 'controller'), 'controller')
c.addConstraint(('driver', 'control.autoPoll'), 'autoPoll')
c.addConstraint(('driver', 'controller'), 'controller')

### Exposed interfaces
c.inheritInterface("signal", ("device", "signal"))
c.inheritInterface("ground", ("device", "ground"))
c.inheritInterface("control", ("driver", "control"))

c.toYaml("library/Buzzer.yaml")

