from svggen.api.component import Component
from svggen.api.Function import Function


self = Component()

self.addSubcomponent("beam", "RectBeam")
self.addSubcomponent("slotsplit", "SplitEdge")
self.addSubcomponent("tabsplit", "SplitEdge")
self.addSubcomponent("progcover", "Rectangle")
self.addSubcomponent("restcover", "Rectangle")
self.addSubcomponent("header", "Header")

self.addParameter("brain")
self.addParameter("length")
self.addParameter("width", 0)
self.addParameter("depth", 0)

### Set specific relationships between parameters
def getBrainParameter(p):
  return "brain", "x.getDimension('%s')" % p

self.addConstraint(("beam", "width"), "depth")
self.addConstraint(("beam", "depth"), "width")
self.addConstraint(("beam", "length"), "length")

self.addConstraint(("beam", "minwidth"), *getBrainParameter("height"))
self.addConstraint(("beam", "mindepth"), *getBrainParameter("width"))
self.addConstraint(("beam", "minlength"), *getBrainParameter("length"))

self.addConstConstraint(("beam", "faces"), range(0,3))

# XXX: doesn't check to see whether minimum length is satisfied
proglength = 6
maxbt = 10

self.addConstraint(("tabsplit", "botlength"), "length", "(x,)")
self.addConstraint(("tabsplit", "toplength"), ("brain", "length"),
                             "(\
                               %d, \
                               x[1] - %d, 0, 0\
                              )" % (proglength, proglength))
"""
                               x[0].getDimension('length') - %d,\
                               min(x[1] - x[0].getDimension('length'), %d),\
                               max(x[1] - x[0].getDimension('length') - %d, 0),\
                              )" % (proglength, proglength, maxbt, maxbt))
                               """

self.addConstraint(("slotsplit", "toplength"), "length", "(x,)")
self.addConstraint(("slotsplit", "botlength"), ("brain", "length"),
                             "(\
                               %d, \
                               x[1] - %d, 0, 0\
                              )" % (proglength, proglength))
"""
                               x[0].getDimension('length') - %d,\
                               min(x[1] - x[0].getDimension('length'), %d),\
                               max(x[1] - x[0].getDimension('length') - %d, 0),\
                              )" % (proglength, proglength, maxbt, maxbt))
                               """

self.addConstraint(("progcover", "w"), *getBrainParameter("width"))
#self.addConstraint(("progcover", "l"), "brain", "x.getDimension('length') - %d" % proglength)
self.addConstraint(("progcover", "l"), "length", "x - %d" % proglength)

self.addConstraint(("restcover", "w"), *getBrainParameter("width"))
self.addConstConstraint(("restcover", "l"), 0)
"""
self.addConstraint(("restcover", "l"), ("brain", "length"),
                                       "max(x[1] - x[0].getDimension('length') - %d, 0)" % maxbt)
"""

self.addConstraint(("header", "nrows"), *getBrainParameter("nrows"))
self.addConstraint(("header", "ncols"), *getBrainParameter("ncols"))
self.addConstraint(("header", "rowsep"), *getBrainParameter("rowsep"))
self.addConstraint(("header", "colsep"), *getBrainParameter("colsep"))

'''
if length < brainlength:
  raise ValueError("Brain module too short")
'''

self.addConnection(("beam", "tabedge"),
                   ("tabsplit", "botedge0"),
                   angle=0)

self.addConnection(("beam", "slotedge"),
                   ("slotsplit", "topedge0"),
                   angle=0)

self.addConnection(("tabsplit", "topedge1"),
                   ("progcover", "t"),
                   angle=90)
self.addConnection(("tabsplit", "topedge3"),
                   ("restcover", "t"),
                   angle=90)

self.addConnection(("slotsplit", "botedge1"),
                   ("progcover", "b"),
                   angle=90, tabWidth=10)
self.addConnection(("slotsplit", "botedge3"),
                   ("restcover", "b"),
                   angle=90, tabWidth=10)

self.addConnection(("beam", "face1"),
                   ("header", "mount"),
                   mode="hole", offset=Function(params=("length", "brain"), fnstring="(0, -0.5 * (x[0]-x[1].getDimension('length')))"))

self.inheritAllInterfaces("beam", prefix=None)

self.toYaml("library/Brains.yaml")
