from Port import Port

class ModularPort(Port):
  def __init__(self, parent, modular):
    Port.__init__(self, parent, {})
    self.modular = modular

  def getModular(self, component=None):
    if component is None:
      return self.modular

    mod = {}
    for k, v in self.modular.iteritems():
      if isinstance(v, dict):
        mod[k] = {}
        for k2, v2 in v.iteritems():
          mod[k][k2] = (component, v2)
      else:
        mod[k] = (component, v)
    return mod

  def getValue(name):
    if modular:
      self.edges = modular['edges']
      self.faces = modular['faces']
      self.length = modular['parameters']

  def canMate(self, otherPort):
    return False
  
  def inherit(self, parent, subc):
    oldModular = self.getModular()
    newModular = {}

    def interfaceHelper(newModular, oldModular, interfaceType):
      newModular[interfaceType] = {}
      for which, name in oldModular[interfaceType].iteritems():
        if isinstance(name, (tuple, list)):
          newModular[interfaceType][which] = []
        for k, v in parent.interfaces.iteritems():
          if v["subcomponent"] == subc:
            if v["interface"] == name:
              newModular[interfaceType][which] = k
              break
            if isinstance(name, (tuple, list)) and v["interface"] in name:
              newModular[interfaceType][which].append(k)

    interfaceHelper(newModular, oldModular, "edges")
    interfaceHelper(newModular, oldModular, "faces")

    def parameterHelper(newModular, oldModular, key):
      oldparam = oldModular["parameters"][key]
      try:
        param = oldparam["parameter"]
        oldfn = oldparam.get("function", "x")
        newparam = parent.subcomponents[subc]["parameters"][param]
      except TypeError:
        # Constant value
        param = None
        oldfn = None
        newparam = oldparam
      if oldfn == "x":
        oldfn = None

      try:
        if "parameter" in newparam:
          if oldfn:
            if "function" in newparam and newparam["function"] != "x":
              print "*** can't function a function"
            else:
              newModular["parameters"][key] = dict(newparam) # copy
              newModular["parameters"][key]["function"] = oldfn
          else:
            newModular["parameters"][key] = newparam
        else: 
          print "*** inheriting modular from", subc
          print "don't know what to do with", key, ":",
          print param
      except TypeError:
        newModular["parameters"][key] = newparam

    newModular["parameters"] = {}
    for key in oldModular["parameters"]:
      parameterHelper(newModular, oldModular, key)

    return ModularPort(parent, newModular)
