from Port import Port
from svggen.utils.utils import prefix as prefixString

class FacePort(Port):
  def __init__(self, parent, graph, face):
    Port.__init__(self, parent, {})
    if graph is not None:
      self.face = graph.getFace(face)
    else:
      self.face = None

  def getFaceName(self):
    return self.face.name

  def toString(self):
    return str(self.face.name)

  def canMate(self, otherPort):
    try:
      return (otherPort.getDecoration() is not None)
    except AttributeError:
      return False
