from Port import Port
from svggen.utils.utils import prefix as prefixString

class EdgePort(Port):
  def __init__(self, parent, edge):
    Port.__init__(self, parent, {})
    self.edge = edge

  def getEdges(self):
    return [self.edge]

  def prefix(self, prefix=""):
    self.edge = prefixString(prefix, self.edge)

  def canMate(self, otherPort):
    try:
      return len(self.getEdges()) == len(otherPort.getEdges())
    except AttributeError:
      return False

  def toString(self):
    return str(self.getEdges())
