from svggen.api.composables.graph.HyperEdge import HyperEdge
import svggen.utils.mymath as np

class Joint:
    def __init__(self, **kwargs):
        self.kwargs = kwargs
    def go(face, edge):
        pass

class FingerJoint(Joint):
    def go(self, face, edge):
        inset = False
        edgename = face.name + edge.name
        index = face.edgeIndex(edge.name)                                       
        angle, flip = edge.faces[face]

        thickness = self.kwargs["thickness"]

        coords = face.edgeCoords(index)
        length = face.edgeLength(index) 
        if inset:
            length -= thickness

        pt1 = np.array(coords[0])
        pt2 = np.array(coords[1])

        n = int(max(3, round(length * 1.0 / thickness))) # number of fingers
        dt = length * 1.0 / n                # actual thickness of fingers
        dlp = thickness / 2. 
        dln = thickness / 2. # Only works for 90deg angles; np.sqrt(2) max
        dl = dlp + dln # actual length of fingers

        flip = flip and (n % 2 == 1)

        dpt = (pt2 - pt1) * 1.0 * dt / face.edgeLength(index)
        ppt = np.array((dpt[1], -dpt[0])) / dt

        newEdges = []
        newPts = []
        newPt = coords[0]

        def addNew(newEdge, newPt):
            newEdges.append(newEdge)
            newPts.append(newPt)
            newEdge.join(newEdge.length, face)

        if inset:
        # inset from the edge for 3 face corners
            newPt = newPt - ppt * dln
            newEdge = HyperEdge(edgename + "fjx1", dln)
            addNew(newEdge, newPt)

            newPt = newPt + dpt * thickness / dt / 2.0
            newEdge = HyperEdge(edgename + "fjx2", dt)
            addNew(newEdge, newPt)

            newPt = newPt + ppt * dln
            newEdge = HyperEdge(edgename + "fjx3", dln)
            addNew(newEdge, newPt)

        if flip:
            newPt = newPt + ppt * dlp
            newEdge = HyperEdge(edgename + "fj0", dlp)
        else:
            newPt = newPt - ppt * dln
            newEdge = HyperEdge(edgename + "fj0", dln)
            

        for i in range(int(n)):
            addNew(newEdge, newPt)

            newPt = newPt + dpt 
            newEdge = HyperEdge(edgename + "fjd%d" % i, dt)
            addNew(newEdge, newPt)

            if flip:
                newPt = newPt - ppt * dl
            else:
                newPt = newPt + ppt * dl
            newEdge = HyperEdge(edgename + "fjp%d" % i, dl)
            flip = not flip

        if not flip:
            addNew(newEdge, newPt)
        else:
            newPt = newPt - ppt * dl

        if inset:
            newPt = newPt + dpt * thickness / dt / 2.0
            newEdge = HyperEdge(edgename + "fjy", dt)
            addNew(newEdge, newPt)

        newEdge = HyperEdge(edgename + "fjn", dln)
        newEdges.append(newEdge)

        return newPts, newEdges
