class Composable:
  def new(self):
    return self.__class__()
  def append(self, newComposable, newPrefix, **kwargs):
    raise NotImplementedError
  def addComponent(self, componentObj):
    pass
  def addInterface(self, newInterface):
    pass

  def attachInterfaces(self, interface1, interface2, kwargs):
    # Interfaces can contain multiple ports, so try each pair of ports
    if not isinstance(interface1, (list, tuple)):
      interface1 = [interface1]
    if not isinstance(interface2, (list, tuple)):
      interface2 = [interface2]
    if len(interface1) != len(interface2):
      raise AttributeError("Number of ports in each interface don't match")

    for (port1, port2) in zip(interface1, interface2):
      self.attach(port1, port2, kwargs)

  def attach(self, fromPort, toPort, kwargs):
    raise NotImplementedError
  def makeOutput(self, filedir, **kwargs):
    raise NotImplementedError
