class Function:
  def __init__(self, params, fnstring=None):
    self.params = params
    self.fnstring = fnstring or "x"

  def toYamlObject(self):
    if self.params is None:
      return eval(obj)
    elif self.fnstring == "x":
      return {"parameter": self.params}
    else:
      return {"function": self.fnstring, "parameter": self.params}

  def fromYamlObject(self, obj):
    if isinstance(obj, dict):
      self.params = obj["parameter"]
      self.fnstring = obj.get("function", "x")
    else:
      self.params = None
      self.fnstring = repr(obj)

  def eval(self, parameterizable):
    import svggen.utils.mymath as np
    function = eval("lambda x : " + self.fnstring, locals())
    if isinstance(self.params, (list, tuple)):
      output = function(map(lambda x : parameterizable.getParameter(x, strict=False), self.params))
    elif self.params:
      output = function(parameterizable.getParameter(self.params, strict=False))
    else:
      output = function(None)
    return output

class ConstantFunction(Function):
  def __init__(self, value):
    Function.__init__(self, None, repr(value))

class IdentityFunction(Function):
  def __init__(self, params):
    Function.__init__(self, params, "x")

class YamlFunction(Function):
  def __init__(self, obj):
    Function.__init__(self, None, None)
    self.fromYamlObject(obj)

