#ifndef INCL_ROBOTLIBRARY_H
#define INCL_ROBOTLIBRARY_H

#include <EEPROM.h>
#define numServos 2
#include "string_functions.h"
#define dataCommand "DATA"
#define dataRequest "GET"
#define uiRequest "UI_DESCRIPTION"
#include "arduino.h"
#include "avr/pgmspace.h"
#define getControllerPin(pinIndex) (int)pgm_read_word(&controllerPins[pinIndex])
#define getPinType(pinIndex) (int)pgm_read_word(&pinTypes[pinIndex])
#define getProtocol(pinIndex) (int)pgm_read_word(&protocol[pinIndex])
#define setDO(pin, newState) (digitalWrite(getControllerPin(pin), newState))
#define setPWM(pin, duty) (analogWrite(getControllerPin(pin), duty))
#define readDI(pin) (digitalRead(getControllerPin(pin)))
#define readAI(pin) (analogRead(getControllerPin(pin)))
#define robotPrintSetup(baud)  Serial.begin(baud)
#define robotPrint(toPrint) Serial.print(toPrint)
#define robotPrintln(toPrint) Serial.println(toPrint)
#define numPins 38
// Define pin types
#define DO 0
#define DI 1
#define AO 2
#define AI 3
#define PO 4 // PWM Output
#define PI 5 // PWM Input
#define SO 6 // Servo Output
#define SI 7 // Servo Input
// Define protocol types
#define PROTOCOL_DIRECT 0
#define PROTOCOL_BLUETOOTH 1
#define getPinMateType(pinIndex)(getPinType(pinIndex) == DO ? DI : (        \
                                 getPinType(pinIndex) == DI ? DO : (        \
                                 getPinType(pinIndex) == PO ? PI : (        \
                                 getPinType(pinIndex) == PI ? PO : (        \
                                 getPinType(pinIndex) == AO ? AI : (        \
                                 getPinType(pinIndex) == AI ? AO : (        \
                                 getPinType(pinIndex) == SO ? SI : (        \
                                 getPinType(pinIndex) == SI ? SO : (        \
                                 -1)))))))))
#define set(pin) (setDO(pin, 1))
#define clear(pin) (setDO(pin, 0))
#define threshAI(pin, threshold) (readAI(pin) > threshold)
#define PRINT_DEBUG 1
#if PRINT_DEBUG == 1
#define robotPrintDebug(toPrint) robotPrint(toPrint)
#define robotPrintlnDebug(toPrint) robotPrintln(toPrint)
#define robotPrintSetupDebug(baud) robotPrintSetup(baud)
#else
#define robotPrintDebug(toPrint)
#define robotPrintlnDebug(toPrint)
#define robotPrintSetupDebug(baud)
#endif
#define NUM_DATA_OUTPUTS 4
#define DATA_OUTDEGREE 1


bool setSpeed(int servoNum, int speed);
void calibrateServo(int servoNum);
void getServoOffsets();
void eepromWriteInt(int address, int value);
int eepromReadInt(int address);
int speedToDuty(double speed, int pin);
bool getBluetoothData();
void sendBluetoothData(const char* data);
void processBluetoothData();
bool isBluetoothConnected();
void setPinMode(int pin, int mode);
long getPWMFrequency(int pinIndex);
int setPWMFrequency(int pin, long frequency);
void robotSetup();
void robotLoop();
void processData();
char* getData(int sourceID);
char* getData(int sourceID, int destID);
void processData(const char* data, int sourceID, int* destIDs, int numDestIDs);
void processData(const char* data, int destID);
void processData(const char* data, int sourceID, int destID);

#endif