from flask import Flask, render_template, request, send_from_directory, abort, jsonify
from wtforms import Form, IntegerField, SubmitField
from os.path import join

from svggen.library import getComponent
from svggen.api.composables.graph.Joint import FingerJoint


known_models = [
    "Stool",
    "SimpleTable",
    "SimpleChair",
    "RockerChair",
    "Paperbot",
]

app = Flask(__name__, static_url_path="/static")


def make(f, path, args, mkstl=True, mkdxf=True): 
    t = 0

    for p, v in args.iteritems():
        try:
            value = float(v)
            if value == int(value):
                value = int(value)
            f.setParameter(p, value)
        except KeyError:
            if p == '$thickness' or p == '%24thickness':
                t = float(v)
        except ValueError:
            pass

    j = None
    if t:
        j = FingerJoint(thickness=t)

    try:
        print join(app.static_folder, path)
        f.makeOutput(join(app.static_folder, path), 
            tree=False, unfolding=False, animate=False, 
            autofolding=False, display=False, 
            silhouette=mkdxf, stl=mkstl, 
            thickness = t, joint = j)
    except Exception as e:
        return repr(e)

@app.route('/', defaults={'path': ''}, methods=['GET', 'POST'])
@app.route('/<path:path>', methods=['GET', 'POST'])
def catchall(path): 
    ext = ""
    if '.' in path:
        try:
            path, ext = path.split('.')
        except ValueError:
            abort(400)

    component = path

    if component:
        try:
            f = getComponent(component)
        except:
            abort(404)

        if ext == "json":
            return jsonify(f.getParameterInfo())
        if ext == "stl":
            make(f, component, request.args, mkstl=True, mkdxf=False)
            return send_from_directory(join(app.static_folder, component), "graph-model.stl", as_attachment=True, cache_timeout=-1)
        elif ext == "dxf":
            make(f, component, request.args, mkstl=False, mkdxf=True)
            return send_from_directory(join(app.static_folder, component), "graph-silhouette.dxf", as_attachment=True, cache_timeout=-1)
        elif ext: 
            abort(400)

        elif request.args:
            make(f, component, request.args)
            return render_template("3d.html", component=component, query=request.query_string)

        else:
            class ParamForm(Form):
                pass
            for k, v in f.parameters.iteritems():
                setattr(ParamForm, k, IntegerField("%s: " % k, default=v))

            return render_template('params.html', form=ParamForm())
        print component
    else:
        string = "<html><body>"
        for m in known_models:
            string += '<a href="' + m + '">' + m + "</a><br>"
        string += "</body></html>"
        return string

if (__name__ == "__main__"): 
    app.run(host= '0.0.0.0', port = 5000) 
