# Requirements

- virtualenv
- pip
- bash

# To install and/or run

From a `bash` shell, run:
```
$ ./vstart.sh
```

If this is your first time running it (if the folder `ENV/` doesn't exist), the script will create a virtualenv in the folder `ENV/`, then install the required packages from `requirements.txt`.

Regardless, it will then start a `bash` shell in this virtualenv, from which you can use `roco`.

# Running RoCo

Example scripts are in the `tests/` folder.  For a simple paper structure, try running `Gripper_Test.py` in the `paper/` folder.  If you are running a headless display, instead run it as a pytest module: 
```
$ cd tests
$ python -m pytest paper/Gripper_Test.py
```
For a simple wooden structure, try running `Stool_Test.py` in the `wood/` folder.

Manufacturing files will be generated in the `output/` directory.

# Webapp

Start the webapp:
```
$ cd flaskapp
$ python app.py
```
Then view the app by going to http://localhost:5000 from a webbrowser.

How to interpret the connection angle:
When user performs c.addConnection(("B","l"),("A","l"), angle=X), the interpretation is that:
(1) Face B (the first argument) is stacked above Face A (the second argument).
(2) Both Face B and Face A have their front side facing toward the same direction D.
(3) Face A (the second argument) will push Face B (the first argument) an angle of X to direction D.

IMPORTANT: To make this compile, in GraphComposable.py makeOutput() function, comment out the if statements from "if kw("unfolding"):" to "if kw("autofolding"):". Please only enable "if kw("stl") to see the 3d file because the other functions are not modified yet.